{-
  Ambidexter is Copyright (c) Prescott K. Turner, 2005. All rights reserved.
  It is distributed as free software under the license in the file "License",
  which is included in the distribution.
-}
module Basic (Way (ByValue, ByName, ByType), TShow, tshow, KShow, kshow, VarName, TypeId,
	SpanDisplay (ShowSpan, NoShowSpan, TopShowSpan), nest,
	MonadicShow, do_show, MonadicKShow, do_kshow, MonadicTShow, do_tshow,
	listsOf, strictList_, strictList,
	Parameterized, namesOf, usedOf, unusedOf, assertWay,
	Substitutable, substitute,
	FoldableTree, foldTree,
	liftState,
	FunctorM, fmapM, FunctorM2, fmapM2,
	die,
	default_type_limit,
	aside
	) where
import List
import Control.Monad.State
import System.Exit
import IO (stderr, hPutStrLn, hPutStr, Handle)

data Way = ByName | ByValue | ByType
    deriving (Eq)
name_kind_of_way :: Way -> String
name_kind_of_way x = case x of
	ByName -> "covalue"
	ByValue -> "value"
	ByType -> "type"

-- Static analysis should diagnose an error if a covariable is used
-- in a term context, or a variable in a coterm context.
assertWay :: Way -> Way -> String -> t -> t
assertWay require actual message
	= if require /= actual
	    then error ("The name is a " ++ name_kind_of_way actual ++ " where a " ++ name_kind_of_way require ++ " is required. " ++ message)
	    else id
assertIOWay :: (MonadIO m) => Way -> Way -> String -> m t -> m t
assertIOWay require actual message act
	= if require /= actual
	    then die ("The name is a " ++ name_kind_of_way actual ++ " where a " ++ name_kind_of_way require ++ " is required. " ++ message)
	    else act

data SpanDisplay = ShowSpan | NoShowSpan | TopShowSpan deriving (Eq)
nest :: SpanDisplay -> SpanDisplay
nest ds = case ds of
		ShowSpan -> ShowSpan
		NoShowSpan -> NoShowSpan
		TopShowSpan -> NoShowSpan

default_type_limit :: Integer
default_type_limit = 10

class KShow t where
	-- The Integer is how much recursion to delve into when displaying the type.
	-- The SpanDisplay is whether to display the span.
	-- The Bool is whether to display the kind along with each type.
	kshow :: Integer -> SpanDisplay -> Bool -> t -> String
class TShow t where
	-- The first Bool is whether to display the type along with each expression.
	-- The second Bool is whether to display the kind along with each type.
	tshow :: SpanDisplay -> Bool -> Bool -> t -> String
class (Monad m) => MonadicShow m tp where
    do_show :: tp -> m String
class (Monad m) => MonadicKShow m tp where
    do_kshow :: Integer -> SpanDisplay -> Bool -> tp -> m String
class (Monad m) => MonadicTShow m tp
    where
	-- As with TShow,
	-- the first Bool is whether to display the type along with each expression.
	-- The second Bool is whether to display the kind along with each type.
	do_tshow :: SpanDisplay -> Bool -> Bool -> tp -> m String

type VarName = String
type TypeId = Int

class Parameterized p where
  namesOf :: p -> [VarName]  -- exposed names
  usedOf :: p -> [VarName]   -- all names
unusedOf :: Parameterized p => p -> [VarName]
unusedOf x = listsOf ['a'..'z'] \\ ("" : usedOf x)

class Substitutable tp e where
  substitute :: VarName -> tp -> e -> e

class FoldableTree e where
  -- The function receives a node plus the
  -- results of processing every subordinate node.
  foldTree :: (e -> [t] -> t) -> e -> t

-- List all the lists of elements from the list l.
listsOf :: [t] -> [[t]]
listsOf l = lists
  where
    lists = [] : do r <- lists
                    i <- l
                    return (i:r)

-- Evaluates the entire list, but not its elements, when the head is evaluated.
strictList_ :: [a] -> [a] 
strictList_ ls = f ls 
    where 
        f (a:as) = f as 
        f [] = ls 

strictList :: [a] -> [a]
strictList ls@(a : more) = seq a $ seq (strictList more) $ ls
strictList ls = ls

class FunctorM t where
	fmapM :: (Monad m) => (a -> m b) -> t a -> m (t b)
class FunctorM2 t where
	fmapM2 :: (Monad m) => (a -> m b) -> (c -> m d) -> t a c -> m (t b d)
instance (FunctorM2 t) => FunctorM (t k) where
	fmapM f = fmapM2 return f

liftState :: (Monad m) => State t a -> StateT t m a
liftState (State f) = StateT (return . f)

die :: (MonadIO m) => String -> m a
die msg = liftIO $ do
		hPutStrLn stderr msg
		exitFailure

trc :: (MonadIO m) => String -> m ()
trc msg = liftIO $ hPutStrLn stderr msg

aside :: (MonadIO m) => Maybe Handle -> String -> m ()
aside verbose msg = case verbose of
	Just h -> liftIO $ hPutStrLn h msg
	Nothing -> return ()
