{-
  Ambidexter is Copyright (c) Prescott K. Turner, 2005. All rights reserved.
  It is distributed as free software under the license in the file "License",
  which is included in the distribution.
-}
module Position (Position(Position), Span(Span), no_pos, no_span,
	Positionable, get_span, set_pos, start_pos_of, end_pos_of, pos_span, is_pos, is_span,
	strace) where

import Debug.Trace

data Position = Position !Int !Int String
data Span = Span Position Position String
instance Show Span where
    show (Span (Position l1 c1 _) (Position l2 c2 _) str)
	= "span from " ++ show l1 ++ "/" ++ show c1 ++ " to " ++ show l2 ++ "/" ++ show c2 ++ " containing " ++ str

no_pos = Position 0 0 ""
no_span = Span no_pos no_pos ""

start_pos_of :: (Positionable p) => p -> Position
start_pos_of x = let (Span start _ _) = get_span x in start
end_pos_of :: (Positionable p) => p -> Position
end_pos_of x = let (Span _ end _) = get_span x in end

class Positionable t where
	set_pos :: Span -> t -> t
	get_span :: t -> Span

strace :: Positionable t => t -> a -> a
strace x whatever = trace (show (get_span x)) whatever

pos_span start_pos@(Position l c str) end_pos
		= Span start_pos end_pos (copy start_pos end_pos str)
	where
		copy cur lim str
		    = if cur `reaches` lim
			then []
			else case str of
				[] -> []
				(x:xs) -> x: copy (advance cur x) lim xs
		advance pos ch = case pos of
		    Position l c [] -> error "can't advance"
		    Position l c (x:xs) -> case ch of
			'\n' -> Position (l+1) 0 xs
			'\t' -> Position l (next_tab (c+1)) xs
			_ -> Position l (c+1) xs
		next_tab col = if col `mod` 8 == 0 then col else next_tab (col+1)
		reaches (Position l1 c1 _) (Position l2 c2 _) = l1 > l2 || (l1 == l2 && c1 >= c2)

is_pos p = case p of
	Position 0 0 "" -> False
	_ -> True
is_span (Span p0 p1 str) = is_pos p0 || is_pos p1 || not (null str)
