/*
  harmonograph is Copyright (c) Prescott K. Turner, 2006. All rights reserved.
  It is distributed as free software under the license in the file "License",
  which is included in the distribution.
*/
#include "canvas.h"
#include "frame.h"
#include "trialview.h"

using namespace std;

// Canvas

BEGIN_EVENT_TABLE(Canvas, wxPanel)
  EVT_PAINT(      Canvas::OnPaint)
END_EVENT_TABLE()

Canvas::Canvas( Frame *parent,
    wxWindowID id, const wxPoint &pos, const wxSize &size )
        : wxPanel( parent, id, pos, size, wxSUNKEN_BORDER, _T("canvas") )
{
    m_owner = parent;

    SetBackgroundColour( wxT("WHITE") );

    // SetCursor( wxCursor( wxCURSOR_IBEAM ) );
}

Canvas::~Canvas()
{
}

void Canvas::OnPaint( wxPaintEvent &WXUNUSED(event) )
{
    wxPaintDC dc( this );
    m_owner->PrepareDC( dc );

    if (m_owner->m_view != 0) {
        m_owner->m_view->OnDraw(&dc);
    }
}

void Canvas::tick(const PendulumsState &ps0, const PendulumsState &ps1)
{
    wxClientDC dc( this );
    m_owner->PrepareDC( dc );
    TrialView::segment(dc, ps0, ps1);
}

void Canvas::clear_screen()
{
    wxClientDC dc( this );
    m_owner->PrepareDC( dc );
    dc.Clear();
}
