/*
  harmonograph is Copyright (c) Prescott K. Turner, 2006. All rights reserved.
  It is distributed as free software under the license in the file "License",
  which is included in the distribution.
*/
#include "wx/wx.h" 
#include "wx/docview.h"
#include "harmonograph.h"
#include "frame.h"
#include "events.h"
#include "docmanager.h"
#include "trialdoc.h"
#include "trialview.h"

using namespace std;

IMPLEMENT_APP(App)

App::App()
    : m_docManager(NULL)
{
}

bool App::OnInit()
{
    // Create a document manager
    m_docManager = new DocManager(NULL);

    // Create a template relating documents to their views.
    (void)new wxDocTemplate(m_docManager, _T("Trial"), _T("*.hgf"), _T(""), _T("hgf"), _T("Trial Doc"), _T("Trial View"),
        CLASSINFO(TrialDocument), CLASSINFO(TrialView));
    
    // Create the main frame window
    ParentFrame *frame = new ParentFrame(m_docManager, (wxFrame *) NULL, -1, _T("Harmonograph"), wxPoint(0, 0), wxSize(200, 300), wxDEFAULT_FRAME_STYLE);
    m_docManager->main_frame = frame;

    // Make a menubar.
    wxMenu *menuFile = new wxMenu;
    
    menuFile->Append(wxID_NEW, _T("&New..."));
    menuFile->Append(wxID_OPEN, _T("&Open..."));
    
    menuFile->AppendSeparator();
    menuFile->Append(ID_About, "&About..." );

    menuFile->AppendSeparator();
    menuFile->Append(wxID_EXIT, _T("E&xit"));
    
    wxMenuBar *menuBar = new wxMenuBar;
    
    menuBar->Append(menuFile, _T("&File"));
    
    // Associate the menu bar with the frame.
    frame->SetMenuBar(menuBar);

    frame->Centre(wxBOTH);
    frame->Show(TRUE);
    
    SetTopWindow(frame); // ??
    return TRUE;
} 

int App::OnExit()
{
    delete m_docManager;
    return 0;
}

// The top-level window of the application.

IMPLEMENT_CLASS(ParentFrame, wxDocParentFrame)
BEGIN_EVENT_TABLE(ParentFrame, wxDocParentFrame)
    EVT_MENU(ID_About, ParentFrame::OnAbout)
END_EVENT_TABLE()

ParentFrame::ParentFrame(wxDocManager *manager, wxFrame *frame, wxWindowID id, const wxString& title,
                 const wxPoint& pos, const wxSize& size, const long type):
wxDocParentFrame(manager, frame, id, title, pos, size, type)
{
}

void ParentFrame::OnAbout(wxCommandEvent& WXUNUSED(event))
{
    wxMessageBox("Harmonograph 1.0, by Scott Turner for Stephen Mathewes",
        "About Harmonograph", wxOK | wxICON_INFORMATION, this);
}
