/*
  harmonograph is Copyright (c) Prescott K. Turner, 2006. All rights reserved.
  It is distributed as free software under the license in the file "License",
  which is included in the distribution.
*/
#ifndef pendulums_h
#define pendulums_h

#include <list>

class wxOutputStream;
class wxInputStream;

extern const double pi;
extern int round2i(double d);
extern double length_to_freq(double length);

struct PendulumState {
    double position; // Force is -2*pi*frequency*position.
    double momentum; // Mass is 1/2*pi*frequency.
};
struct PendulumsState {
    PendulumState x;
    PendulumState y;
    double time;
};

class Pendulum {
public:
    Pendulum(double freq, double phase, double energy);
    void set_state(double position, double momentum);
    void set_energy(double energy, double phase);
    void get_state(double &position, double &momentum);

    bool advance(double time, double friction_force, double friction_magnitude);
private:
    PendulumState state;
    double frequency;
};

class Pendulums {
public:
    Pendulums(double x_freq, double y_freq, double x_phase, double y_phase,
	      double x_energy, double y_energy,
	      double friction_magnitude);
    bool advance(double time);
    void clear_history();
    PendulumsState get_state();
    std::list<PendulumsState> &get_history();
    void pause(bool);
    wxOutputStream& save_history(wxOutputStream& stream);
    wxInputStream& load_history(wxInputStream& stream);
private:
    Pendulum x_pendulum;
    Pendulum y_pendulum;
    double time;
    double friction_magnitude;
    std::list<PendulumsState> pendulums_history;
    bool paused;
    bool done;
};

#endif
