/*
  harmonograph is Copyright (c) Prescott K. Turner, 2006. All rights reserved.
  It is distributed as free software under the license in the file "License",
  which is included in the distribution.
*/
#ifndef trialdoc_h
#define trialdoc_h

#include "wx/docview.h"
#include "pendulums.h"

class TrialDocument: public wxDocument
{
    DECLARE_DYNAMIC_CLASS(TrialDocument)
public:
    
    wxOutputStream& SaveObject(wxOutputStream& stream);
    wxInputStream& LoadObject(wxInputStream& stream);
    
    TrialDocument(void);
    ~TrialDocument(void);

    std::list<PendulumsState> &get_pendulums_history();
    PendulumsState get_pendulums_state();
    Pendulums *pendulums;
    bool set_pendulums(wxString &diagnostic);
    void cancel_motion();

    wxString y_phase, x_phase, x_length, y_length;
    wxString x_amplitude, y_amplitude, friction;
};

#endif
